// Direct-Sequence Spread Spectrum (DSSS) Modulation and Demodulation
// OS: Windows 10
// Scilab Version: 6.1.0
// Course Instructor: Dr. V. A. Sankar Ponnapalli
// Institute: ICFAI Foundation for Higher Education Hyderabad

clc;
clear;
close;

N_bits = input("Enter number of data bits (e.g., 10 to 100): ");
PG = input("Enter processing gain (e.g., 5 to 20): ");
fc = input("Enter carrier frequency in Hz (e.g., 1000): ");
fs = input("Enter sampling frequency in Hz (must be > 10*fc): ");

// Validations
if fs <= 10 * fc then
    error("Sampling frequency must be greater than 10 times the carrier frequency.");
end

// Timing and signal parameters
Tb = 1e-3;                    // Bit duration (1 ms)
Tc = Tb / PG;                 // Chip duration
Ns = int(fs * Tb);            // Samples per bit
Nc = int(fs * Tc);            // Samples per chip
total_samples = N_bits * Ns;  // Total number of samples
t = (0:total_samples - 1) / fs;  // Time vector

// Generate random data bits (+1 or -1)
data_bits = 2 * grand(1, N_bits, "uin", 0, 2) - 1;
data_signal = matrix(ones(Ns, 1) * data_bits, 1, -1);

// Generate PN sequence long enough
num_chips = N_bits * PG;
pn_seq = 2 * grand(1, num_chips, "uin", 0, 2) - 1;
pn_signal_full = matrix(ones(Nc, 1) * pn_seq, 1, -1);

// Ensure PN signal has enough samples
if length(pn_signal_full) < total_samples then
    // Pad if too short
    extra_needed = total_samples - length(pn_signal_full);
    pn_signal_full = [pn_signal_full, ones(1, extra_needed)];
end
pn_signal = pn_signal_full(1:total_samples);  // Trim to exact length

// Spread signal
spread_signal = data_signal .* pn_signal;

// Carrier
carrier = cos(2 * %pi * fc * t);

// Modulate
modulated_signal = spread_signal .* carrier;

// Receiver: Demodulate
received = modulated_signal .* carrier;
despread = received .* pn_signal;

// Recover bits
recovered_bits = zeros(1, N_bits);
for i = 1:N_bits
    idx_start = (i - 1) * Ns + 1;
    idx_end = i * Ns;
    recovered_bits(i) = sign(sum(despread(idx_start:idx_end)));
end

// Plot
clf();
subplot(3,1,1);
plot(t, spread_signal);
xtitle("Spread Signal using PN Sequence");
xlabel("Time (s)");
ylabel("Amplitude");

subplot(3,1,2);
plot(t, modulated_signal);
xtitle("BPSK Modulated Signal");
xlabel("Time (s)");
ylabel("Amplitude");

subplot(3,1,3);
plot(t, despread);
xtitle("Despread Signal at Receiver");
xlabel("Time (s)");
ylabel("Amplitude");

// Display bits
disp("Original bits: ");
disp(data_bits);
disp("Recovered bits: ");
disp(recovered_bits);

// Description of the Figure
// User Inputs:
// Enter number of data bits (e.g., 10 to 100): 100
// Enter processing gain (e.g., 5 to 20): 10
// Enter carrier frequency in Hz (e.g., 1000): 1000
// Enter sampling frequency in Hz (must be > 10*fc): 11000
//  The figure depicts Direct-Sequence Spread Spectrum  Modulation and Demodulation.
